 ; Need to modify repall to do only one ssget for each entity type
 ; and then to reuse those sses; this allows changing to a selected
 ; text only mode.
 ; as it is a new ssget is done for each change list, which is not optimal
 ; or obvious when the code is being changed.
 ; Also Repall doesn't do mtext.

 ; Ŀ
 ;   Mepall - chgtext for every text entity and attribute in a drawing.    
 ;   This variant of Repall also changes text and mtext contained in       
 ;   blocks.                                                               
 ;   A variant of Chall.lsp with no prompts, designed for batch file use.  
 ;   Copyright 1995, 1997, 1998, 2004, 2008 by Rocket Software Ltd.        
 ;   If knowledge is power then why are idiots so dangerous?               
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Ent - search and replace for text/mtext in block definitions.         
 ; 
 (DEFUN ENT (oldstr newstr / ach bch tchs reww blokdat first blnam)
  (setq ach 0)         ; number of attdefs changed
  (setq bch 0)         ; number of block definitions changed
  (setq tchs 0)        ; total number of changes
 ; Ŀ
 ;   Change all blocks.                                                    
 ; 
  (setq reww T)
  (while (setq blokdat (tblnext "block" reww))
         (setq reww ())
         (setq first (substr (setq blnam (cdr (assoc 2 blokdat))) 1 1))
         (if (/= first "*")
             (progn
                  (setq namm (cdr (assoc -2 blokdat)))
                  (setq chgs (tuskt namm oldstr newstr))
                  (if (> (car chgs) 0) (setq bch (1+ bch)))
                  (setq ach (+ ach (car chgs)))
                  (setq tchs (+ tchs (cadr chgs))))))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (write-line (strcat (itoa tchs) " change" (if (/= tchs 1) "s" "") " in "
                      (itoa ach) " text/mtext entit"
                                            (if (/= ach 1) "ies" "y") " in "
                      (itoa bch) " block definition" (if (/= bch 1) "s." ".")))
 (princ))
 ; Ŀ
 ;   Ent end.                                                              
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Multch - change one substring to another in everything.               
 ;   Arguments: CC - the old string                                        
 ;              DD - the new string                                        
 ;              Notouch - the list of block names not to modify            
 ;              LLen - the cycle number/number of replace cycles string    
 ;   Returns a list: number of changes in text, number of text entities    
 ;   changed, number of changes in attributes, number of attributes.       
 ; 
 (DEFUN MULTCH (cc dd notouch llen / ccp chlin chnum rad ss len num changs
                strch enam txt entt altr mods newtxt pa chaags attch esub chg)
  (setq chlin 0)
  (setq chnum 0)
  (setq rad (/ (getvar "viewsize") 45))
  (setq ss (ssget "X" (list (cons 0 "TEXT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Txt " llen)))
  (setq num 0)
  (setq changs 0)
  (setq strch 0)
  (while (and ss (setq enam (ssname ss num)))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq altr (chug cc dd txt))
         (if (> (setq mods (cadr altr)) 0)           ; if any changes made
                (progn
                     (setq newtxt (car altr))
                     (setq changs (+ changs mods))
                     (setq strch (1+ strch))
                     (setq pa (cdr (assoc 10 entt)))
                     (mark pa rad 1)
                     (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt)))))
  (setq num 0)
  (setq chaags 0)
  (setq attch 0)
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (if ss (setq len (strcat "/" (itoa (sslength ss)) ":Att")))
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa (setq num (1+ num))) len))
         (setq chg ())
         (while (and (not (member (cdr (assoc 2 (entget enam))) notouch))
                     (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub))))))
                (setq txt (cdr (assoc 1 entt)))
                (setq altr (chug cc dd txt))
                (if (> (setq mods (cadr altr)) 0)        ; if any changes made
                    (progn
                         (setq chg T)
                         (setq newtxt (car altr))
                         (setq chaags (+ chaags mods))
                         (setq attch (1+ attch))
                         (setq pa (cdr (assoc 10 entt)))
                         (mark pa rad 7)
                         (entmod (subst (cons 1 newtxt) (assoc 1 entt) entt))))
                (setq esub (entnext esub)))
         (if chg (entupd enam)))
 (list changs strch chaags attch))
 ; Ŀ
 ;   Multch end.                                                           
 ; 

 ; Ŀ
 ;   Tuskt - change a prompt string in the block tables.                   
 ;   Notes: 1. Entnext returns nil after the last entity in a block        
 ;             definition.                                                 
 ;          2. An empty block has one subentity of type Endblk.            
 ;   Takes 3 arguments - the first subentity ename, the search string      
 ;   and the replacement string.                                           
 ;   Returns a list of the number of prompt strings changed and the        
 ;   total number of changes.                                              
 ; 
 (DEFUN TUSKT (namm oldstr newstr / attchg chgnum entt typ prom1 prom2 altr
                                                              mods nup namm)
  (setq attchg 0)
  (setq chgnum 0)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (setq typ (cdr (assoc 0 entt)))
         (if (and (member typ '("TEXT" "MTEXT"))
                  (setq prom1 (assoc 1 entt)))
             (progn
                  (setq prom2 (cdr prom1))
                  (setq altr (chug oldstr newstr prom2))
                  (if (> (setq mods (cadr altr)) 0)      ; if any changes made
                      (progn
                           (setq nup (car altr))
                           (entmod (subst (cons 1 nup) prom1 entt))
                           (setq attchg (1+ attchg))
                           (setq chgnum (+ chgnum mods))))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (list attchg chgnum))
 ; Ŀ
 ;   Tuskt end.                                                            
 ; 

 ; Ŀ
 ;   Mepall - the controller.                                              
 ; 
 (DEFUN C:MEPALL (/ chlist notouch changs strch chaags attch num sub llen
                                                       oldstr newstr chglst)
  (setvar "cmdecho" 0)
  (command "undo" "m")
 ; Ŀ
 ;   This next section is the one to edit.                                 
 ;   The format is ("existing string" "new string"), each line will do     
 ;   one search and replace, in the order they are in here.                
 ;                                                                         
 ;   Watch out for cascades: A to B, B to C, C to D gives all D.           
 ;   C to D, B to C, A to B works properly.                                
 ;   Also 1 to 5, 10 to 20 gives 10 to 50 instead of 10 to 20.             
 ;   10 to 20, 1 to 5 still doesn't work, but 10 to *20*, 1 to 5,          
 ;   and then *20* to 20 can be used if you are careful.                   
 ;   For text the longest common substring should be used - watch for      
 ;   the combination SP to JF which results in SPARE to JFARE.             
 ;   And keep backups, because you can't catch everything.                 
 ; 
  (setq chlist '(
                 ("CS NACE" "316 SS")
                 ("A106B" "A312")
                 ("A105N" "A182")
                 ("A234 WPB" "A182")
                 ("304 SS" "316 SS")
                 ))
 ; Ŀ
 ;   End of search and replace string section.                             
 ; 
  (setq notouch ())
  (setq changs 0)
  (setq strch 0)
  (setq chaags 0)
  (setq attch 0)
  (setq num 0)
  (while (setq sub (nth num chlist))
         (setq num (1+ num))
         (setq llen (strcat (itoa num) "/" (itoa (length chlist))))
         (setq oldstr (car sub))
         (setq newstr (cadr sub))
 ; Ŀ
 ;   Change text and blocks.                                               
 ; 
         (setq chglst (multch oldstr newstr notouch llen))
 ; Ŀ
 ;   Change text and mtext in block definitions.                           
 ;   Ent displays its own change data.                                     
 ; 
         (ent oldstr newstr)
 ; Ŀ
 ;   Sum up and debrief the user.                                          
 ; 
         (setq changs (+ changs (nth 0 chglst)))
         (setq strch (+ strch (nth 1 chglst)))
         (setq chaags (+ chaags (nth 2 chglst)))
         (setq attch (+ attch (nth 3 chglst))))
  (write-line (strcat (itoa changs) " change" (if (/= changs 1) "s" "") " in "
                      (itoa strch) " text string"  (if (/= strch 1) "s." ".")))
  (write-line (strcat (itoa chaags) " change" (if (/= chaags 1) "s" "") " in "
                      (itoa attch) " attribute" (if (/= attch 1) "s." ".")))
 (princ))